package game;

import game.BusyPanel;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

import javax.swing.JOptionPane;

public class PackerUnpackerFromSnag {
	
	public static void main(String [] args) {
		PackerUnpackerFromSnag i = new PackerUnpackerFromSnag();
		
//		i.pack("E:\\Snag\\ship's hold copy\\ship_hold.snag");
//		System.out.println("the output file is in place.");
		
//		i.testPack();
		
		i.unpack("E:\\Snag\\unpack test", "E:\\Snag\\ship's hold copy\\ship_hold.snagpak");
		System.out.println("okay...let's see if she's unpacked...");
	}
	
	private void testPack() {
		
		try {
			FileInputStream in = new FileInputStream("E:\\Snag\\ship's hold\\images\\good_bag_game_over_backup.GIF");
			
			FileOutputStream out = new FileOutputStream("E:\\Snag\\unpack test\\test_image_out.GIFpack");
			
			int inputter = -1;
			
			ArrayList<Integer> intArray = new ArrayList<Integer>();
			
			while((inputter = in.read()) != -1) {
				intArray.add(inputter);
			}
			
			in.close();
			
			
			byte fileName[] = "E:\\Snag\\unpack test\\test_image_out_five.GIF\n".getBytes();
			out.write(fileName);
			
			byte charCount[] = (Integer.toString(intArray.size()) + "\n").getBytes();
			out.write(charCount);
			
			for(Integer theInt : intArray) {
				out.write(theInt.intValue());
			}
			
			
			out.flush();
			out.close();
			
			
			
			System.out.println("...just wrote the pack file.  Getting it out again?  Hoo, that's gonna be a doozy...");
			
			in = new FileInputStream("E:\\Snag\\unpack test\\test_image_out.GIFpack");
			
//			ArrayList<Byte> byteArray = new ArrayList<Byte>();
//			inputter = in.read();
//			while(inputter != -1 && inputter != '\n' && inputter != '\r') {
//				byteArray.add(new Byte((byte) inputter));
//				inputter = in.read();
//			}
//			String outFileName = convertByteArrayListToString(byteArray);
			String outFileName = readLineFromStream(in);
			out = new FileOutputStream(outFileName);
			
//			byteArray = new ArrayList<Byte>();
//			inputter = in.read();
//			while(inputter != -1 && inputter != '\n' && inputter != '\r') {
//				byteArray.add(new Byte((byte) inputter));
//				inputter = in.read();
//			}
//			String charCountStr = convertByteArrayListToString(byteArray);
			String charCountStr = readLineFromStream(in);
			long charCountInt = Long.parseLong(charCountStr);
			
			for(int i = 0; i < charCountInt; i++) {
				out.write(in.read());
			}
			
			
			out.flush();
			out.close();
			
			in.close();
			
			
			System.out.println("okay...let's see what THAT file looks like; read from both a bufferedReader AND a FileInputStream.  We'll see how that goes.");
			
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	
	private String convertByteArrayListToString(ArrayList<Byte> arrayList) {
		
		StringBuffer returnValue = new StringBuffer();
		
		for(Byte b : arrayList) {
			returnValue.append((char) b.byteValue());
		}
		
		
		System.out.println("let's see if this is proper; the returnValue is:  <<" + returnValue + ">>");
		return returnValue.toString();
	}
	
	private String readLineFromStream(InputStream in) throws IOException {
		
		ArrayList<Byte> byteArray = new ArrayList<Byte>();
		int inputter = in.read();
		while(inputter != -1 && inputter != '\n' && inputter != '\r') {
			byteArray.add(new Byte((byte) inputter));
			inputter = in.read();
		}
		
		return convertByteArrayListToString(byteArray);
		
	}
	
	public void unpack(String folder, String snagPackFileName) {
		
		try {
			
			BusyPanel.showWaitBox(BusyPanel.UNPACK, null);
			
			FileInputStream in = new FileInputStream(snagPackFileName);
			
			for(int i = 0; i < 37; i++) {
				unpackSnagFile(in, folder);
			}
			
			while(unpackBinaryFile(in, folder)) {
				System.out.println("...seems we've written something out...");
			}
			
			BusyPanel.hideWaitBox();
			
			JOptionPane.showMessageDialog(null, "Files were unpacked successfully!", "Unpack Successful!", JOptionPane.INFORMATION_MESSAGE);
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			BusyPanel.hideWaitBox();
		}
		
	}
	
	public void unpackSnagFile(InputStream in, String folder) throws IOException {
		
		String inputter = readLineFromStream(in);
		String fileName = inputter.replace("*", folder + "/");
		
		System.out.print("read in: <<" + inputter + ">> for the snag file name.  New file will be called: <<" + fileName + ">>.");
		
		BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
		inputter = readLineFromStream(in);
		long countOfRows = Long.parseLong(inputter);
		
		System.out.println("...and <<" + fileName + ">> will have this many rows: " + countOfRows);
		
		for(long i = 0; i < countOfRows; i++) {
			inputter = readLineFromStream(in);
			out.write(decodeAsterisks(inputter, folder));
			out.newLine();
		}
		
		out.flush();
		out.close();
		
	}
	
	private String decodeAsterisks(String inputter, String folder) {
		
		if(!inputter.contains("*"))
			return inputter;
		
		return inputter.replace("*", folder);
		
		
	}
	
	
	public boolean unpackBinaryFile(InputStream in, String folder) throws IOException {
		
		String inputter = readLineFromStream(in);
		if(inputter == null || inputter.length() == 0) {
			System.out.println("we tried to get the name of the binary file; what did we input, just now?  <<" + inputter + ">>");
			if(inputter.length() == 0) {
				inputter = readLineFromStream(in);
				if(inputter == null || inputter.length() == 0) {
					System.out.println("...second time didn't work either; got this: <<" + inputter + ">>");
					return false;
				}
			}
			
		}
		String fileName = inputter.replace("*", folder + "/");
		
		System.out.print("just read in a binary file name: " + inputter + ", which will be called <<" + fileName + ">>");
		
		FileOutputStream out = new FileOutputStream(fileName);
		
		inputter = readLineFromStream(in);
		if(inputter == null || inputter.length() == 0) {
			System.out.println("we tried to get the count of characers in the binary file; what did we input, just now?  <<" + inputter + ">>");
			return false;
		}
		long countOfChars = Long.parseLong(inputter);
		
		System.out.println("...and the count of characters: " + countOfChars);
		
		boolean returnValue = true;
		int reader = -1;
		
		for(long i = 0; i < countOfChars; i++) {
			reader = in.read();
			if(reader == -1) {
				returnValue = false;
				System.out.println("the in.read method got a -1, oddly...");
				break;
			}
			out.write(reader);
		}
		
		out.flush();
		out.close();
		
		System.out.println("about to return this from unpackBinaryFile");
		return returnValue;
		
	}
	
	
	public void pack(String masterFile) {
		
		HashMap<String, Long> imageFiles = new HashMap<String, Long>();
		HashMap<String, Long> audioFiles = new HashMap<String, Long>();
		String audioFileNameRaw = null;
		String audioFileNameNew = null;
		HashMap<String, Long> snagFileNames = new HashMap<String, Long>();
		
		
		
		try {
			
			BusyPanel.showWaitBox(BusyPanel.PREPARE, null);
			
			snagFileNames.put(masterFile, null);
			BufferedReader masterIn = new BufferedReader(new FileReader(masterFile));
			
			String inputter = null;
			
			inputter = masterIn.readLine();  //file name
			inputter = masterIn.readLine();  //------
			
			FileOutputStream packedOut = new FileOutputStream(masterFile + "pak");
			
			inputter = masterIn.readLine();
			snagFileNames.put(inputter, null);
			getAudioFileLengths(inputter, audioFiles); //audio file
			inputter = masterIn.readLine();
			snagFileNames.put(inputter, null);
			getBoxFileLengths(inputter, imageFiles); //boxes file
			inputter = masterIn.readLine();
			snagFileNames.put(inputter, null);
			getItemFileLengths(inputter, imageFiles); //item file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/normal non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/normal non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/normal non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/normal snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/normal snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/normal snagging file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/large non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/large non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/large non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/large snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/large snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/large snagging file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/shrinking non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/shrinking non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/shrinking non-snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player normal/shrinking snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player fast/shrinking snagging file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getPlayerAnimationFileLengths(inputter, imageFiles); //player slowing/shrinking snagging file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getSnaggerFileLengths(inputter, imageFiles); //snagger normal/normal file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getSnaggerFileLengths(inputter, imageFiles); //snagger fast/normal file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getSnaggerFileLengths(inputter, imageFiles); //snagger slowing/normal file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger normal/large file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger fast/large file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger slowing/large file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger normal/shrinking file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger fast/shrinking file
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getLargeSnaggerFileLengths(inputter, imageFiles); //snagger slowing/shrinking file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getHeldItemFileLengths(inputter, imageFiles); //dragged net file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getHeldItemFileLengths(inputter, imageFiles); //dragged bomb file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getDeployedNetFileLengths(inputter, imageFiles); //deployed net file
			
			inputter = masterIn.readLine(); 
			snagFileNames.put(inputter, null);
			getBlastFileLengths(inputter, imageFiles); //natch
			
			getBackgroundFileLengthsDoNotClose(masterIn, imageFiles); //background
			getBackgroundFileLengthsDoNotClose(masterIn, imageFiles); //title screen
			getBackgroundFileLengthsDoNotClose(masterIn, imageFiles); //bad ending
			getBackgroundFileLengthsDoNotClose(masterIn, imageFiles); //normal ending
			getBackgroundFileLengthsDoNotClose(masterIn, imageFiles); //good ending
			
			inputter = masterIn.readLine();
			snagFileNames.put(inputter, null);
			getScoreboardFileLengths(inputter, imageFiles); //scoreboard files
			
			inputter = masterIn.readLine();
			snagFileNames.put(inputter, null);
			getOverlayPanelsWorthOfLengths(inputter, imageFiles); //overlay files
			
			getLengthsOfSnagFiles(snagFileNames);
			
			
			HashMap<String, String> smallFileNamesToBig = new HashMap<String, String>();
			HashMap<String, String> bigFileNamesToSmall = new HashMap<String, String>();
			
			
			determineBestFileNames(smallFileNamesToBig, bigFileNamesToSmall, snagFileNames, audioFiles, imageFiles);
			
			BusyPanel.hideWaitBox();
			
			
			BusyPanel.showWaitBox(BusyPanel.PACK, null);
			
			
			Set<String> keys = snagFileNames.keySet();
			System.out.println("size of snagFileNames: " + keys.size());
			for(String key : keys) {
				writeSnagFileContents(key, snagFileNames.get(key), packedOut, bigFileNamesToSmall);
			}
			
			
			keys = audioFiles.keySet();
			System.out.println("size of audioFiles: " + keys.size());
			for(String key : keys) {
				writeBinaryFileContents(key, audioFiles.get(key), packedOut, bigFileNamesToSmall);
			}
			
			
			keys = imageFiles.keySet();
			System.out.println("size of imageFiles: " + keys.size());
			for(String key : keys) {
				writeBinaryFileContents(key, imageFiles.get(key), packedOut, bigFileNamesToSmall);
			}
			
			masterIn.close();
			
			packedOut.flush();
			packedOut.close();
			
			BusyPanel.hideWaitBox();
			
			JOptionPane.showMessageDialog(null, "Packed file is: " + masterFile + "pak","Successfully Packed!", JOptionPane.INFORMATION_MESSAGE);
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Error; unable to find the appropriate directories or files!", "File Error", JOptionPane.ERROR_MESSAGE);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Error while trying to read from/write to the files!", "File Error", JOptionPane.ERROR_MESSAGE);
			
		} finally {
			BusyPanel.hideWaitBox();
		}
		
		
	}
	
	private void getAudioFileLengths(String fileName, HashMap<String, Long> audioFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		
		long tempLength = 0L;
		
		String inputter = null;
		
		for(int i= 0; i < 12; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, audioFiles);
		}
		
		uberIn.close();
		
		
	}
	
	
	private void getBoxFileLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {
		
		
		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		BufferedReader unterIn = null;
		
		String inputter = null;
		long tempLength = 0L;
		
		for(int i = 0; i < 6; i++)
			uberIn.readLine();
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 normal animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 slowed animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 unslowing animation
		
		inputter = uberIn.readLine();
		
		if(inputter.trim().equalsIgnoreCase("reset")) {
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 normal snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 slowed snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box1 unslowing snagged animation
		}
		
		
		
		for(int i = 0; i < 6; i++)
			uberIn.readLine();
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 normal animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 slowed animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 unslowing animation
		
		inputter = uberIn.readLine();
		
		if(inputter.trim().equalsIgnoreCase("reset")) {
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 normal snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 slowed snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box2 unslowing snagged animation
		}
		
		
		
		for(int i = 0; i < 6; i++)
			uberIn.readLine();
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 normal animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 slowed animation
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 unslowing animation
		
		inputter = uberIn.readLine();
		
		if(inputter.trim().equalsIgnoreCase("reset")) {
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 normal snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 slowed snagged animation
			getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //box3 unslowing snagged animation
		}
		
		
	}
	
	public void getCustomAnimationPanelsWorthOfLengths(BufferedReader uberIn, HashMap<String, Long> imageFiles) throws IOException {
		
		int countOfFrames = 0;
		
		String inputter = uberIn.readLine();
		countOfFrames = Integer.parseInt(inputter);
		
		for(int i = 0; i < countOfFrames; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
	}
	
	public void getSnaggedAnimationPanelsWorthOfLengths(BufferedReader uberIn, HashMap<String, Long> imageFiles) throws IOException {
		
		String inputter = uberIn.readLine();
		
		for(int i = 0; i < 11; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
	}
	
	private void checkLengthOfFile(String file, HashMap<String, Long> fileLengthMap) throws IOException {
		
		if(file == null || file.length() < 1 || file.trim().equalsIgnoreCase("blank") || fileLengthMap.containsKey(file))
			return;
		
		System.out.println("now checking the length of file: <<" + file + ">>");
		BufferedReader in = new BufferedReader(new FileReader(file));
		
		long lengthOfFile = 0L;
		
		while(in.read() != -1) {
			lengthOfFile++;
		}
		in.close();
		
		fileLengthMap.put(file, lengthOfFile);
		
		
	}
	
	
	public void getItemFileLengths(String itemFileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(itemFileName));
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //normal animation
		
		String inputter = uberIn.readLine();
		if(!inputter.trim().equalsIgnoreCase("reset"))
			return;
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //radius snagged animations
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //speed snagged animations
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //slow snagged animations
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //bomb snagged animations
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //net snagged animations
		
		for(int i = 0; i < 9; i++)
			uberIn.readLine();
		getSnaggedAnimationPanelsWorthOfLengths(uberIn, imageFiles); //level down snagged animations
		
		uberIn.close();
		
	}
	
	
	public void getPlayerAnimationFileLengths(String playerFileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(playerFileName));
		
		String inputter = uberIn.readLine();
		
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //still
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up-left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down-left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down-right
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //right
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up-right
		
		uberIn.close();
		
	}
	
	public void getPlayerAnimationFileLengths(BufferedReader uberIn, HashMap<String, Long> imageFiles) throws IOException {
		
		String inputter = uberIn.readLine();
		
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //still
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up-left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down-left
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //down-right
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //right
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //up-right
		
		uberIn.close();
		
	}
	
	private void getHeldItemFileLengths(String heldItemFile, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(heldItemFile));
		
		String inputter = uberIn.readLine();
		
		if(inputter.trim().equalsIgnoreCase("change")) {
			getPlayerAnimationFileLengths(uberIn, imageFiles);
		} else {
			getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles);
		}
		
		uberIn.close();
		
	}
	
	
	private void getSnaggerFileLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		
		String inputter = null;
		
		for(int i = 0; i < 11; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
		
		uberIn.close();
		
	}
	
	private void getLargeSnaggerFileLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {

		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		
		String inputter = null;
		
		for(int i = 0; i < 16; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
		
		uberIn.close();
		
	}
	
	private void getDeployedNetFileLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader in = new BufferedReader(new FileReader(fileName));
		
		in.readLine();
		
		getCustomAnimationPanelsWorthOfLengths(in, imageFiles); //deployING
		getCustomAnimationPanelsWorthOfLengths(in, imageFiles); //deployED
		getCustomAnimationPanelsWorthOfLengths(in, imageFiles); //fading
		
		in.close();
		
	}

	public void getBlastFileLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		
		int countOfFrames = 37;
		String inputter = null;
		
		for(int i = 0; i < countOfFrames; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
		uberIn.close();
		
	}
	
	public void getBackgroundFileLengthsDoNotClose(BufferedReader in, HashMap<String, Long> imageFiles) throws IOException {
		
		String inputter = in.readLine();
		int countOfFrames = Integer.parseInt(inputter);
		
		for(int i = 0; i < countOfFrames; i++) {
			inputter = in.readLine();
			checkLengthOfFile(inputter, imageFiles);
		}
		
		
	}
	
	public void getScoreboardFileLengths(String scoreBoardFileName, HashMap<String, Long> imageFiles) throws IOException {
		
		BufferedReader uberIn = new BufferedReader(new FileReader(scoreBoardFileName));
		
		String inputter = uberIn.readLine();
		
		getBackgroundFileLengthsDoNotClose(uberIn, imageFiles);
		
		for(int i = 0; i < 12; i++)
			uberIn.readLine();
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 0
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 1
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 2
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 3
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 4
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 5
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 6
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 7
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 8
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //one's place 9
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 0
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 1
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 2
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 3
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 4
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 5
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 6
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 7
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 8
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //ten's place 9
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 0
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 1
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 2
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 3
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 4
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 5
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 6
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 7
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 8
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //hundred's place 9
		
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 0
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 1
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 2
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 3
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 4
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 5
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 6
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 7
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 8
		getCustomAnimationPanelsWorthOfLengths(uberIn, imageFiles); //thousand's place 9
		
		uberIn.close();
		
	}
	
	public void getOverlayPanelsWorthOfLengths(String fileName, HashMap<String, Long> imageFiles) throws IOException {
		
		
		BufferedReader uberIn = new BufferedReader(new FileReader(fileName));
		
		int countOfFrames = 0;
		
		String inputter = uberIn.readLine();
		countOfFrames = Integer.parseInt(inputter);
		
		for(int i = 0; i < countOfFrames; i++) {
			inputter = uberIn.readLine();
			checkLengthOfFile(inputter, imageFiles);
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
			inputter = uberIn.readLine();
		}
		
		uberIn.close();
	}
	
	
	public void getLengthsOfSnagFiles(HashMap<String, Long> snagFileLength) throws IOException {
		
		Set<String> keys = snagFileLength.keySet();
		
		for(String key : keys) {
			getRowsOfSnagFile(key, snagFileLength);
		}
		
		
	}
	
	public void getRowsOfSnagFile(String fileName, HashMap<String, Long> snagFileLengths) throws IOException {
		
		BufferedReader in = new BufferedReader(new FileReader(fileName));
		
		long rows = 0L;
		
		while(in.readLine() != null)
			rows++;
		
		snagFileLengths.put(fileName, rows);
		
		in.close();
		
	}
	
	public void determineBestFileNames(
			HashMap<String, String> smallToBigNames, 
			HashMap<String, String> bigToSmallNames,
			HashMap<String, Long> snagFileLengths,
			HashMap<String, Long> audioFileLengths,
			HashMap<String, Long> imageFileLengths
			) {
		
		Set<String> keys = snagFileLengths.keySet();
		
		int indexOfSlash = -1;
		
		String tempName = null;
		
		for(String key : keys) {
			
			System.out.println(">>snag file>>" + key + "<<");
			
			indexOfSlash = Math.max(key.lastIndexOf('/'), key.lastIndexOf('\\'));
			tempName = "*" + key.substring(indexOfSlash + 1);
						
			for(int i = 0; !key.equals(smallToBigNames.get(tempName)) && smallToBigNames.containsKey(tempName); i++) {
				tempName = "*c" + i + "_" + key.substring(indexOfSlash + 1);
			}
			
			smallToBigNames.put(tempName, key);
			bigToSmallNames.put(key, tempName);
			
		}
		
		
		keys = audioFileLengths.keySet();
		
		for(String key : keys) {
			
			System.out.println("))audio file))" + key + "((");
			
			indexOfSlash = Math.max(key.lastIndexOf('/'), key.lastIndexOf('\\'));
			tempName = "*" + key.substring(indexOfSlash + 1);
						
			for(int i = 0; !key.equals(smallToBigNames.get(tempName)) && smallToBigNames.containsKey(tempName); i++) {
				tempName = "c" + i + "_" + key.substring(indexOfSlash + 1);
			}
			
			smallToBigNames.put(tempName, key);
			bigToSmallNames.put(key, tempName);
			
		}
		
		
		keys = imageFileLengths.keySet();
		
		for(String key : keys) {

			System.out.println("]]image file]]" + key + "[[");
			
			indexOfSlash = Math.max(key.lastIndexOf('/'), key.lastIndexOf('\\'));
			tempName = "*" + key.substring(indexOfSlash + 1);
						
			for(int i = 0; !key.equals(smallToBigNames.get(tempName)) && smallToBigNames.containsKey(tempName); i++) {
				tempName = "c" + i + "_" + key.substring(indexOfSlash + 1);
			}
			
			smallToBigNames.put(tempName, key);
			bigToSmallNames.put(key, tempName);
			
		}
		
		
		keys = bigToSmallNames.keySet();
		for(String key : keys) {
			System.out.println("=======big name:  >" + key + "< ...and a small one: >" + bigToSmallNames.get(key) + "<");
		}
		
		
	}
	
	
	public void writeSnagFileContents(String snagFileName, long length, OutputStream out, HashMap<String, String> bigToSmallNames) throws IOException {
		
		
		if(bigToSmallNames.containsKey(snagFileName)) {
			out.write(bigToSmallNames.get(snagFileName).getBytes());
		} else {
			out.write(snagFileName.getBytes());
		}
		out.write("\n".getBytes());
		out.write(Long.toString(length).getBytes());
		out.write("\n".getBytes());
		
		BufferedReader in = new BufferedReader(new FileReader(snagFileName));
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			
			if(bigToSmallNames.containsKey(inputter)) {
				out.write(bigToSmallNames.get(inputter).getBytes());
			} else {
				out.write(inputter.getBytes());
			}
			out.write("\n".getBytes());
			
		}
		
		
	}
	
	public void writeBinaryFileContents(String fileName, long length, OutputStream out, HashMap<String, String> bigToSmallNames) throws IOException {
		
		out.write(bigToSmallNames.get(fileName).getBytes());
		out.write("\n".getBytes());
		
		out.write(Long.toString(length).getBytes());
		out.write("\n".getBytes());
		
		FileInputStream in = new FileInputStream(fileName);
		
		int inputter;
		long countOfChars = 0L;
		
		while((inputter = in.read()) != -1) {
			out.write(inputter);
			countOfChars++;
		}
		
		out.write("\n".getBytes());
		
		if(countOfChars != length) {
			System.out.println("the binary file " + fileName + " was expected to have " + length + " characters, but in fact had " + countOfChars);
		} else {
			System.out.println("the binary file " + fileName + " was expected to have " + length + " characters, and did.");
		}
		
		in.close();
		
	}
	
}
